#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>

#define NEODREDJENO 0
#define SMER1 1
#define SMER2 2

#define BROJ_VOZILA 30

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond1auto = PTHREAD_COND_INITIALIZER;
pthread_cond_t cond1bus = PTHREAD_COND_INITIALIZER;
pthread_cond_t cond1kamion = PTHREAD_COND_INITIALIZER;
pthread_cond_t cond2auto = PTHREAD_COND_INITIALIZER;
pthread_cond_t cond2bus = PTHREAD_COND_INITIALIZER;
pthread_cond_t cond2kamion = PTHREAD_COND_INITIALIZER;

int auti_na_mostu1 = 0;
int busevi_na_mostu1 = 0;
int kamioni_na_mostu1 = 0;
// koliko kojih tipova vozila ima na mostu iz smera 1

int auti_na_mostu2 = 0;
int busevi_na_mostu2 = 0;
int kamioni_na_mostu2 = 0;
// koliko kojih tipova vozila ima na mostu iz smera 2

int na_mostu = 0;
// koliko je vozila trenutno na mostu, smer se moze promeniti samo kad je na mostu 0 zato je jedna promenljiva za koliko je vozila na mostu

int smer = NEODREDJENO;
// prvo je ovako ko prvi zakljuca on menja smer, sledeca prilika je tek kad se most skroz oslobodi i ponovo ide borba za smer tj mutex prvo

void check(long id, char *msg, int smer)
{
    if(smer == SMER1)
        printf("T%ld %s | NA MOSTU=%d auti=%d busevi=%d kamioni=%d\n", id, msg,na_mostu, auti_na_mostu1, busevi_na_mostu1, kamioni_na_mostu1);
    else
        printf("T%ld %s | NA MOSTU=%d auti=%d busevi=%d kamioni=%d\n", id, msg,na_mostu, auti_na_mostu2, busevi_na_mostu2, kamioni_na_mostu2);
}
// sluzi za ispis u kriticnim sekcijama kako bi se videlo koliko je vozila na mostu i kog tipa pri ulasku vozila i pri izlasku vozila

void *predji_most_smer1(void *x)
{
    long id = (long)x;

    int tip_vozila = rand() % 3;

    sleep(rand() % 3);
    printf("Vozilo %ld (%s) prilazi mostu iz smera 1!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));

    pthread_mutex_lock(&mutex);

    while(smer == SMER2 || (smer == SMER1 && (tip_vozila == AUTO && kamioni_na_mostu1 != 0)))
        pthread_cond_wait(&cond1auto, &mutex);
    // ako je smer suprotan ili ako je smer moj, auto sam i ima kamiona spavaj

    while(smer == SMER2 || (smer == SMER1 && (tip_vozila == AUTOBUS && (busevi_na_mostu1 != 0 || kamioni_na_mostu1 != 0))))
        pthread_cond_wait(&cond1bus, &mutex);
    // ako je smer suprotan ili ako je smer moj, autobus sam i ima kamiona ili autobusa spavaj

    while(smer == SMER2 || (smer == SMER1 && (tip_vozila == KAMION && na_mostu != 0)))
        pthread_cond_wait(&cond1kamion, &mutex);
    // ako je smer suprotan ili ako je smer moj, kamion sam i ima bilo ko na mostu spavaj

    smer = SMER1;
    na_mostu++;
    if(tip_vozila == AUTO)
        auti_na_mostu1++;
    else if(tip_vozila == AUTOBUS)
        busevi_na_mostu1++;
    else
        kamioni_na_mostu1++;
    check(id,"SMER1 IN", smer);
    pthread_mutex_unlock(&mutex);

    printf("Vozilo %ld (%s) prelazi most iz smera 1!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila == 1 ? "AUTOBUS" : "KAMION"));
    sleep(rand() % 3);

    pthread_mutex_lock(&mutex);

    na_mostu--;
    if(tip_vozila == AUTO)
        auti_na_mostu1--;
    else if(tip_vozila == AUTOBUS)
        busevi_na_mostu1--;
    else
        kamioni_na_mostu1--;
    check(id,"SMER1 OUT", smer);
    if(tip_vozila == AUTO && na_mostu != 0)
    {
        if(busevi_na_mostu1 == 0)
            pthread_cond_signal(&cond1bus);
        pthread_cond_broadcast(&cond1auto);
    }
    else if(tip_vozila == AUTOBUS && na_mostu != 0)
    {
        pthread_cond_signal(&cond1bus);
        pthread_cond_broadcast(&cond1auto);
    }
    else if(tip_vozila == KAMION || na_mostu == 0)
    {
        smer = NEODREDJENO;
        pthread_cond_broadcast(&cond1auto);
        pthread_cond_signal(&cond1bus);
        pthread_cond_signal(&cond1kamion);
        pthread_cond_broadcast(&cond2auto);
        pthread_cond_signal(&cond2bus);
        pthread_cond_signal(&cond2kamion);
    }
    // ako je izasao auto i ima neko na mostu prvi if ako nema buseva salje se signal jednom busu nema potrebe broadcast, i autima broadcast jer oni nemaju ogranicenje
    // drugi if ako je izasao bus i ako ima neko na mostu, ima samo auta, pa signal busu jednom jer nema smisla broadcast i broadcast autima
    // zadnje ako je kamion ili ako je most prazan smer ide na neodredjeno ko prvi zakljuca mutex zauzece traku i signal po jednom busu iz svakog smera i kamionu, jer samo po jedan moze pa nema smisla vise i broadcast svim autima iz oba smera

    pthread_mutex_unlock(&mutex);

    printf("Vozilo %ld (%s) je preslo most iz smera 1!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
    sleep(rand() % 3);

    return NULL;
}

// smer 2 samo suprotno od prvog smera

void *predji_most_smer2(void *x)
{
    long id = (long)x;

    int tip_vozila = rand() % 3;

    sleep(rand() % 3);
    printf("Vozilo %ld (%s) prilazi mostu iz smera 1!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));

    pthread_mutex_lock(&mutex);

    while(smer == SMER1 || (smer == SMER2 && (tip_vozila == AUTO && kamioni_na_mostu2 != 0)))
        pthread_cond_wait(&cond2auto, &mutex);

    while(smer == SMER1 || (smer == SMER2 && (tip_vozila == AUTOBUS && (busevi_na_mostu2 != 0 || kamioni_na_mostu2 != 0))))
        pthread_cond_wait(&cond2bus, &mutex);

    while(smer == SMER1 || (smer == SMER2 && (tip_vozila == KAMION && na_mostu != 0)))
        pthread_cond_wait(&cond2kamion, &mutex);

    smer = SMER2;
    na_mostu++;
    if(tip_vozila == AUTO)
        auti_na_mostu2++;
    else if(tip_vozila == AUTOBUS)
        busevi_na_mostu2++;
    else
        kamioni_na_mostu2++;
    check(id,"SMER2 IN", smer);
    pthread_mutex_unlock(&mutex);

    printf("Vozilo %ld (%s) prelazi most iz smera 2!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
    sleep(rand() % 3);

    pthread_mutex_lock(&mutex);

    na_mostu--;
    if(tip_vozila == AUTO)
        auti_na_mostu2--;
    else if(tip_vozila == AUTOBUS)
        busevi_na_mostu2--;
    else
        kamioni_na_mostu2--;
    check(id,"SMER2 OUT", smer);
    if(tip_vozila == AUTO && na_mostu != 0)
    {
        if(busevi_na_mostu2 == 0)
            pthread_cond_signal(&cond2bus);
        pthread_cond_broadcast(&cond2auto);
    }
    else if(tip_vozila == AUTOBUS && na_mostu != 0)
    {
        pthread_cond_signal(&cond2bus);
        pthread_cond_broadcast(&cond2auto);
    }
    else if(tip_vozila == KAMION || na_mostu == 0)
    {
        smer = NEODREDJENO;
        pthread_cond_broadcast(&cond2auto);
        pthread_cond_signal(&cond2bus);
        pthread_cond_signal(&cond2kamion);
        pthread_cond_broadcast(&cond1auto);
        pthread_cond_signal(&cond1bus);
        pthread_cond_signal(&cond1kamion);
    }

    pthread_mutex_unlock(&mutex);

    printf("Vozilo %ld (%s) je preslo most iz smera 2!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
    sleep(rand() % 3);

    return NULL;
}

// auti_na_mostu != 0 || busevi_na_mostu != 0 || kamioni_na_mostu != 0

int main()
{
    srand(time(NULL));
    pthread_t vozilasm1[BROJ_VOZILA];
    pthread_t vozilasm2[BROJ_VOZILA];

    for(long i = 0; i < BROJ_VOZILA; i++)
    {
        pthread_create(vozilasm1 + i, NULL, predji_most_smer1, (void *) i);
    }

    for(long i = 0; i < BROJ_VOZILA; i++)
    {
        pthread_create(vozilasm2 + i, NULL, predji_most_smer2, (void *) i);
    }

    for(long i = 0; i < BROJ_VOZILA; i++)
        pthread_join(vozilasm1[i], NULL);

    for(long i = 0; i < BROJ_VOZILA; i++)
        pthread_join(vozilasm2[i], NULL);

    printf("Sva vozila su presla most!\n");

    pthread_exit(NULL);
}

// #include <stdio.h>
// #include <stdlib.h>
// #include <time.h>
// #include <unistd.h>
// #include <pthread.h>

// #define NEODREDJENO 0
// #define SMER1 1
// #define SMER2 2

// #define BROJ_VOZILA 10

// #define AUTO 0
// #define AUTOBUS 1
// #define KAMION 2

// pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
// pthread_cond_t cond1 = PTHREAD_COND_INITIALIZER;
// pthread_cond_t cond2 = PTHREAD_COND_INITIALIZER;

// int auti_na_mostu;
// int busevi_na_mostu;
// int kamioni_na_mostu;

// int na_mostu;

// int smer = NEODREDJENO;

// void check2(long id, char *msg)
// {
//     printf("T%ld %s | NA MOSTU=%d auti=%d busevi=%d kamioni=%d\n", id, msg,na_mostu, auti_na_mostu, busevi_na_mostu, kamioni_na_mostu);

// }

// void *predji_most_smer1(void *x)
// {
//     long id = (long)x;

//     int tip_vozila = rand() % 3;

//     printf("Vozilo %ld (%s) prilazi mostu iz smera 1!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
//     sleep(rand() % 3);

//     pthread_mutex_lock(&mutex);

//     while(smer == SMER2 || (smer == SMER1 && ((tip_vozila == AUTO && kamioni_na_mostu != 0) || (tip_vozila == AUTOBUS && (busevi_na_mostu != 0 || kamioni_na_mostu != 0)) || (tip_vozila == KAMION && na_mostu != 0))))
//         pthread_cond_wait(&cond1, &mutex);

//     smer = SMER1;
//     na_mostu++;
//     if(tip_vozila == AUTO)
//         auti_na_mostu++;
//     else if(tip_vozila == AUTOBUS)
//         busevi_na_mostu++;
//     else
//         kamioni_na_mostu++;
//     check2(id,"SMER1 IN");
//     pthread_mutex_unlock(&mutex);

//     printf("Vozilo %ld (%s) prelazi most iz smera 1!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
//     sleep(rand() % 3);

//     pthread_mutex_lock(&mutex);

//     na_mostu--;
//     if(tip_vozila == AUTO)
//         auti_na_mostu--;
//     else if(tip_vozila == AUTOBUS)
//         busevi_na_mostu--;
//     else
//         kamioni_na_mostu--;
//     check2(id,"SMER1 OUT");
//     if(na_mostu == 0)
//     {
//         smer = NEODREDJENO;
//         pthread_cond_broadcast(&cond1);
//         pthread_cond_broadcast(&cond2);
//     }

//     pthread_mutex_unlock(&mutex);

//     return NULL;
// }

// void *predji_most_smer2(void *x)
// {
//     long id = (long)x;

//     int tip_vozila = rand() % 3;

//     printf("Vozilo %ld (%s) prilazi mostu iz smera 2!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
//     sleep(rand() % 3);

//     pthread_mutex_lock(&mutex);

//     while(smer == SMER1 || (smer == SMER2 && ((tip_vozila == AUTO && kamioni_na_mostu != 0) || (tip_vozila == AUTOBUS && (busevi_na_mostu != 0 || kamioni_na_mostu != 0)) || (tip_vozila == KAMION && na_mostu != 0))))
//         pthread_cond_wait(&cond2, &mutex);

//     smer = SMER1;
//     na_mostu++;
//     if(tip_vozila == AUTO)
//         auti_na_mostu++;
//     else if(tip_vozila == AUTOBUS)
//         busevi_na_mostu++;
//     else
//         kamioni_na_mostu++;
//     check2(id,"SMER2 IN");
//     pthread_mutex_unlock(&mutex);

//     printf("Vozilo %ld (%s) prelazi most iz smera 2!\n", id, tip_vozila == 0 ? "AUTO" : (tip_vozila ==1 ? "AUTOBUS" : "KAMION"));
//     sleep(rand() % 3);

//     pthread_mutex_lock(&mutex);

//     na_mostu--;
//     if(tip_vozila == AUTO)
//         auti_na_mostu--;
//     else if(tip_vozila == AUTOBUS)
//         busevi_na_mostu--;
//     else
//         kamioni_na_mostu--;
//     check2(id,"SMER2 OUT");
//     if(na_mostu == 0)
//     {
//         smer = NEODREDJENO;
//         pthread_cond_broadcast(&cond1);
//         pthread_cond_broadcast(&cond2);
//     }

//     pthread_mutex_unlock(&mutex);

//     return NULL;
// }

// // auti_na_mostu != 0 || busevi_na_mostu != 0 || kamioni_na_mostu != 0

// int main()
// {
//     pthread_t vozilasm1[BROJ_VOZILA];
//     pthread_t vozilasm2[BROJ_VOZILA];

//     for(long i = 0; i < BROJ_VOZILA; i++)
//     {
//         pthread_create(vozilasm1 + i, NULL, predji_most_smer1, (void *) i);
//     }

//     for(long i = 0; i < BROJ_VOZILA; i++)
//     {
//         pthread_create(vozilasm2 + i, NULL, predji_most_smer2, (void *) i);
//     }

//     for(long i = 0; i < BROJ_VOZILA; i++)
//         pthread_join(vozilasm1[i], NULL);

//     for(long i = 0; i < BROJ_VOZILA; i++)
//         pthread_join(vozilasm2[i], NULL);

//     printf("Sva vozila su presla most!\n");

//     pthread_exit(NULL);
// }